---
generated_at: 2026-02-05 10:35:00
metrics:
  claims_total: 8
  claims_with_evidence: 8
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：58-TerminalMenus rawモード失敗警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：8 / 8、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `stdlib/REPL/src/TerminalMenus/AbstractMenu.jl` 191-197行目 - rawモード切り替えの try-catch ブロック
- E-02: `stdlib/REPL/src/TerminalMenus/AbstractMenu.jl` 195行目 - `@warn "TerminalMenus: Unable to enter raw mode: "` 通知
- E-03: `stdlib/REPL/src/TerminalMenus/AbstractMenu.jl` 192行目 - `REPL.Terminals.raw!(term, true)` 呼び出し
- E-04: `stdlib/REPL/src/TerminalMenus/AbstractMenu.jl` 195行目 - `suppress_output ||` 条件による出力制御
- E-05: `stdlib/REPL/src/TerminalMenus/AbstractMenu.jl` 196行目 - `raw_mode_enabled = false` 設定
- E-06: `stdlib/REPL/src/TerminalMenus/AbstractMenu.jl` 238-243行目 - finally ブロックでのrawモード解除
- E-07: `stdlib/REPL/src/TerminalMenus/AbstractMenu.jl` 199行目 - rawモード有効時のカーソル非表示
- E-08: `stdlib/REPL/src/TerminalMenus/AbstractMenu.jl` 181行目 - `request` 関数シグネチャ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | raw! 呼び出し失敗時に @warn で通知される | E-02 | ○ |
| C-02 | REPL.Terminals.raw!(term, true) でrawモード切り替えを試みる | E-03 | ○ |
| C-03 | suppress_output が true の場合は警告出力が抑制される | E-04 | ○ |
| C-04 | 失敗時に raw_mode_enabled = false が設定される | E-05 | ○ |
| C-05 | finally ブロックで rawモード有効時のみ解除処理が行われる | E-06 | ○ |
| C-06 | rawモード有効時にカーソル非表示ESCAPEシーケンスが送信される | E-07 | ○ |
| C-07 | exception パラメータで例外詳細がログに含まれる | E-02 | ○ |
| C-08 | rawモードなしでもメニュー操作ループは続行される | E-01, E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードにより直接裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] `@warn` メッセージのフォーマットが設計書と一致するか確認
- [ ] `suppress_output` 条件の論理が正確か確認（`suppress_output || @warn` は `suppress_output` が false の場合のみ `@warn` が実行される）
- [ ] rawモードなしでのメニュー操作の制限事項を確認
